/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.report;

import com.quantumdata.fmteditor.FmtEditorMain;
import com.quantumdata.fmteditor.InstrumentListener;
import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.file.FileSelectDlg;
import com.quantumdata.fmteditor.file.FmtFileType;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmtwidgets.ConnectPanel;
import com.quantumdata.fmteditor.fmtwidgets.FmtFrameBase;
import com.quantumdata.fmteditor.fmtwidgets.FmtTransferable;
import com.quantumdata.fmteditor.fmtwidgets.PathSelectPanel;
import com.quantumdata.fmteditor.report.ConfigureDialog;
import com.quantumdata.fmteditor.report.FmtReport;
import com.quantumdata.fmteditor.report.FmtTable;
import com.quantumdata.fmteditor.report.FmtTableEntry;
import com.quantumdata.fmteditor.report.FmtTableModel;
import com.quantumdata.fmteditor.report.HtmlSummaryReport;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDProgressBar;
import com.quantumdata.widgets.QDStdUI;
import com.quantumdata.widgets.QDToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FmtReportFrame
extends FmtFrameBase
implements ActionListener,
InstrumentListener,
ItemListener,
ListSelectionListener,
TableModelListener,
TableColumnModelListener {
    private static final long serialVersionUID = 1L;
    private static int g_nextId = 0;
    private FmtTable m_table;
    private QDPanel m_statusPanel;
    private QDButton m_cancelBtn;
    private QDLabel m_fillPath;
    private JProgressBar m_progBar;
    private PathSelectPanel m_paths;
    private ConnectPanel m_connect;
    private QDButton m_edit;
    private QDButton m_use;
    private QDButton m_saveAsHtml;
    private QDButton m_configure;
    private QDButton m_fill;
    private Filler m_filler;
    private boolean m_fillCanceled = false;
    private FmtReport m_report = new FmtReport();
    private boolean m_restore = false;
    private boolean m_modified = false;

    public FmtReportFrame(FmtReport fmtReport) {
        super("", true, true, true, true);
        this.m_report = fmtReport;
        this.init();
        this.m_restore = true;
    }

    public FmtReportFrame() {
        super("", true, true, true, true);
        String string = "FmtReport" + ++g_nextId;
        this.m_report.setFileName(string);
        this.init();
    }

    private void init() {
        this.setFileType(FmtFileType.REPORT);
        this.setLayout(new BorderLayout());
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        qDPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        qDPanel.setPreferredSize(new Dimension(670, 400));
        QDPanel qDPanel2 = new QDPanel((LayoutManager)new BorderLayout());
        QDPanel qDPanel3 = new QDPanel((LayoutManager)new BorderLayout());
        this.m_connect = new ConnectPanel((JComponent)((Object)this));
        this.m_connect.useCompactForm(true);
        qDPanel3.add((Component)((Object)this.m_connect), (Object)"North");
        this.m_paths = new PathSelectPanel(FmtFileType.FORMAT, this);
        this.m_paths.enableTypeSelection(false);
        qDPanel3.add((Component)((Object)this.m_paths), (Object)"South");
        qDPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        qDPanel2.add((Component)qDPanel3, (Object)"North");
        QDToolBar qDToolBar = this.createToolBar();
        qDPanel2.add((Component)qDToolBar, (Object)"South");
        qDPanel.add((Component)qDPanel2, (Object)"North");
        this.createStatusPanel();
        qDPanel.add((Component)this.m_statusPanel, (Object)"South");
        this.m_table = new FmtTable();
        this.m_table.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jScrollPane.getViewport().setBackground(QDStdUI.getBackground());
        jScrollPane.setOpaque(true);
        jScrollPane.setBackground(QDStdUI.getBackground());
        qDPanel.add((Component)jScrollPane);
        this.add((Component)qDPanel);
        this.m_table.getData().addColumn("DVIC");
        this.m_table.getData().addColumn("HTOT");
        this.m_table.getData().addColumn("HRES");
        this.m_table.getData().addColumn("HSPP");
        this.m_table.getData().addColumn("HRAT");
        this.m_table.getData().addColumn("VTOT");
        this.m_table.getData().addColumn("VRES");
        this.m_table.getData().addColumn("VSPP");
        this.m_table.getData().addColumn("VRAT");
        this.m_table.getData().addColumn("SCAN");
        this.m_connect.setListener(this);
        this.m_paths.setItemListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.getColumnModel().addColumnModelListener(this);
        this.m_table.getData().addTableModelListener(this);
        this.m_table.setTransferHandler(new FmtTableTransfer());
        this.m_table.setDragEnabled(true);
        this.m_fill.setEnabled(false);
        this.m_edit.setEnabled(false);
        this.m_use.setEnabled(false);
        this.enableWithCheck();
        try {
            this.m_paths.readPath();
        }
        catch (InstrumentException instrumentException) {
            MsgLog.error(instrumentException.getMessage());
            this.m_connect.setInstrument(null);
        }
    }

    private QDToolBar createToolBar() {
        QDToolBar qDToolBar = new QDToolBar();
        this.m_configure = new QDButton(" Configure ");
        this.m_configure.useSmallFont(true);
        this.m_configure.setActionCommand("config");
        this.m_configure.addActionListener((ActionListener)this);
        this.m_configure.setToolTipText("Configure the table");
        qDToolBar.add((Component)this.m_configure);
        this.m_fill = new QDButton("  Fill  ");
        this.m_fill.useSmallFont(true);
        this.m_fill.setActionCommand("fill");
        this.m_fill.addActionListener((ActionListener)this);
        this.m_fill.setToolTipText("Fill the table with data from the connected instrument");
        qDToolBar.add((Component)this.m_fill);
        this.m_saveAsHtml = new QDButton(" Generate HTML Report ");
        this.m_saveAsHtml.useSmallFont(true);
        this.m_saveAsHtml.setActionCommand("html");
        this.m_saveAsHtml.addActionListener((ActionListener)this);
        this.m_saveAsHtml.setToolTipText("Save the report as an HTML file (printable)");
        qDToolBar.add((Component)this.m_saveAsHtml);
        qDToolBar.addSeparator();
        qDToolBar.addSeparator();
        qDToolBar.addSeparator();
        qDToolBar.addSeparator();
        this.m_edit = new QDButton("  Edit Format  ");
        this.m_edit.useSmallFont(true);
        this.m_edit.setActionCommand("edit");
        this.m_edit.addActionListener((ActionListener)this);
        this.m_edit.setToolTipText("Open the selected format in an editor");
        qDToolBar.add((Component)this.m_edit);
        this.m_use = new QDButton("  Use Format ");
        this.m_use.useSmallFont(true);
        this.m_use.setActionCommand("use");
        this.m_use.addActionListener((ActionListener)this);
        this.m_use.setToolTipText("Use the selected format on the connected instrument");
        qDToolBar.add((Component)this.m_use);
        return qDToolBar;
    }

    public void connected(RemoteInstrument remoteInstrument) {
        this.enableWithCheck();
        try {
            this.m_paths.readPath();
        }
        catch (InstrumentException instrumentException) {
            MsgLog.error(instrumentException.getMessage());
            this.m_connect.setInstrument(null);
        }
    }

    public void disconnected(RemoteInstrument remoteInstrument) {
        this.enableWithCheck();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.pathSelected();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableWithCheck();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setModified(true);
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.setModified(true);
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
            this.setModified(true);
        }
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void editFormat() {
        String string = this.getFormatName();
        if (string == null) {
            return;
        }
        FmtEditorMain.instance().openFormat(string, this);
    }

    private void useFormat() {
        String string = this.getFormatName();
        if (string == null) {
            return;
        }
        MsgLog.clearStatus();
        if (!this.isConnected()) {
            return;
        }
        RemoteInstrument remoteInstrument = this.m_connect.getInstrument();
        try {
            remoteInstrument.tryCommand("FMTL " + string + ";FMTU");
        }
        catch (InstrumentException instrumentException) {
            MsgLog.error("Format Use failed: " + instrumentException.getMessage());
        }
    }

    private String getFormatName() {
        int n = this.m_table.getSelectedRow();
        FmtTableEntry fmtTableEntry = this.m_table.getData().getEntry(n);
        if (fmtTableEntry == null) {
            return null;
        }
        return fmtTableEntry.fullName();
    }

    private void createStatusPanel() {
        this.m_statusPanel = new QDPanel((LayoutManager)new BorderLayout());
        this.m_progBar = new QDProgressBar();
        this.m_statusPanel.add((Component)this.m_progBar, (Object)"Center");
        this.m_progBar.setVisible(false);
        this.m_fillPath = new QDLabel("  ");
        this.m_statusPanel.add((Component)this.m_fillPath, (Object)"West");
        this.m_cancelBtn = new QDButton("Cancel");
        this.m_statusPanel.add((Component)this.m_cancelBtn, (Object)"East");
        this.m_cancelBtn.setActionCommand("cancel");
        this.m_cancelBtn.addActionListener((ActionListener)this);
        this.m_cancelBtn.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("cancel")) {
            this.cancelUpdate();
        } else if (string.equals("config")) {
            this.configureTable();
        } else if (string.equals("fill")) {
            this.fillTable();
        } else if (string.equals("html")) {
            this.saveAsHtml();
        } else if (string.equals("edit")) {
            this.editFormat();
        } else if (string.equals("use")) {
            this.useFormat();
        }
    }

    private void pathSelected() {
        try {
            this.m_paths.writePath();
            this.m_paths.readPath();
        }
        catch (InstrumentException instrumentException) {
            MsgLog.error(instrumentException.getMessage());
            this.m_connect.setInstrument(null);
        }
    }

    private void cancelUpdate() {
        this.m_fillCanceled = true;
    }

    private void fillTable() {
        if (this.m_filler != null) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        MsgLog.clearStatus();
        this.m_filler = new Filler();
        this.m_fillCanceled = false;
        this.disableAll();
        this.m_fillPath.setText("");
        this.showProgress("Reading Format List");
        this.m_table.getData().clear();
        this.m_filler.start();
    }

    private void disableAll() {
        this.m_fill.setEnabled(false);
        this.m_edit.setEnabled(false);
        this.m_use.setEnabled(false);
        this.m_paths.setEnabled(false);
        this.m_connect.setEnabled(false);
        this.m_configure.setEnabled(false);
        this.m_saveAsHtml.setEnabled(false);
    }

    private void enableWithCheck() {
        if (this.m_filler != null) {
            return;
        }
        this.m_connect.setEnabled(true);
        this.m_configure.setEnabled(true);
        boolean bl = this.isConnected();
        boolean bl2 = this.m_table.getSelectedRow() >= 0;
        this.m_edit.setEnabled(bl && bl2);
        this.m_use.setEnabled(bl && bl2);
        this.m_paths.setEnabled(bl);
        this.m_fill.setEnabled(bl);
        this.m_saveAsHtml.setEnabled(this.m_table.getData().getRowCount() > 0);
        this.displayFillPath();
    }

    private void fillComplete() {
        if (!this.isVisible()) {
            return;
        }
        if (this.m_fillCanceled) {
            MsgLog.error("Table fill canceled");
        }
        this.hideProgress();
        this.m_table.getData().entriesCompleted();
        this.setModified(true);
        this.m_filler = null;
        this.enableWithCheck();
    }

    protected void loadTable() {
        RemoteInstrument remoteInstrument = this.getInstrument();
        FmtTableModel fmtTableModel = this.m_table.getData();
        Vector<CmdValue> vector = fmtTableModel.getColumnValues();
        try {
            this.m_paths.writePath();
            String string = remoteInstrument.tryQuery("FMTQ? 1 9999", 120000);
            String[] stringArray = string.split("\r\n");
            this.startProgress(0, stringArray.length, "");
            this.m_table.getData().setCapacity(stringArray.length);
            int n = 0;
            for (String string2 : stringArray) {
                FmtTableEntry fmtTableEntry;
                if (this.m_fillCanceled) break;
                if (!this.isVisible()) {
                    return;
                }
                if ((string2 = string2.trim()).length() == 0) continue;
                this.setProgress(++n, string2);
                if (!this.isVisible()) {
                    return;
                }
                if (!remoteInstrument.command("FMTL " + string2 + " 1")) continue;
                String string3 = remoteInstrument.tryQuery("FMTL?");
                if (vector.size() == 0) {
                    fmtTableEntry = new FmtTableEntry(string3, null);
                    fmtTableModel.addEntry(fmtTableEntry);
                    continue;
                }
                CmdValue[] cmdValueArray = new CmdValue[vector.size()];
                if (this.m_fillCanceled) break;
                if (!this.isVisible()) {
                    return;
                }
                int n2 = 0;
                for (CmdValue cmdValue : vector) {
                    String string4 = remoteInstrument.tryQuery(cmdValue.getCmd() + "?");
                    cmdValueArray[n2] = cmdValue.clone();
                    cmdValueArray[n2].set(string4);
                    ++n2;
                    if (this.m_fillCanceled) break;
                    if (this.isVisible()) continue;
                    return;
                }
                if (this.m_fillCanceled) break;
                fmtTableEntry = new FmtTableEntry(string3, cmdValueArray);
                fmtTableModel.addEntry(fmtTableEntry);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FmtReportFrame.this.fillComplete();
                }
            });
        }
        catch (InstrumentException instrumentException) {
            MsgLog.error("Table fill failed: " + instrumentException.getMessage());
            this.m_filler = null;
            this.m_connect.setInstrument(null);
        }
    }

    public FmtReport getData() {
        return this.m_report;
    }

    public String getDataName() {
        return this.m_report.getFileName();
    }

    public String getTypeName() {
        return "Format Report";
    }

    public boolean isModified() {
        return this.m_modified;
    }

    public boolean isSaveable() {
        return true;
    }

    public void markUnmodified() {
        this.setModified(false);
    }

    public void frameClosing() {
        this.m_connect.close();
    }

    private void setModified(boolean bl) {
        this.m_modified = bl;
        this.setFrameTitle();
    }

    private void showProgress(String string) {
        this.m_progBar.setVisible(true);
        this.m_cancelBtn.setVisible(true);
        this.m_progBar.setIndeterminate(true);
        this.m_progBar.setStringPainted(true);
        this.m_progBar.setString(string);
        this.m_fillPath.setText("");
    }

    private void startProgress(int n, int n2, String string) {
        SwingUtilities.invokeLater(new ProgStarter(n, n2, string));
    }

    private void setProgress(int n, String string) {
        SwingUtilities.invokeLater(new ProgSetter(n, string));
    }

    private void hideProgress() {
        this.m_progBar.setIndeterminate(false);
        this.m_progBar.setVisible(false);
        this.m_cancelBtn.setVisible(false);
        this.displayFillPath();
    }

    private void displayFillPath() {
        int n = this.m_table.getSelectedRow();
        if (n < 0) {
            this.m_fillPath.setText("");
            return;
        }
        FmtTableEntry fmtTableEntry = this.m_table.getData().getEntry(n);
        this.m_fillPath.setText("Source Path: " + fmtTableEntry.path());
    }

    public void captureReport() {
        this.m_table.saveTo(this.m_report);
    }

    private void restoreReport() {
        this.m_table.restoreFrom(this.m_report);
        this.setModified(false);
        this.enableWithCheck();
    }

    public void setAsActive(boolean bl) {
        super.setAsActive(bl);
        this.m_table.configureHeader();
        if (this.m_restore) {
            this.m_restore = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FmtReportFrame.this.restoreReport();
                }
            });
        }
    }

    private void saveAsHtml() {
        MsgLog.clearStatus();
        String string = this.getDataName().toLowerCase();
        if (string.endsWith(FmtFileType.REPORT.extension())) {
            string = this.getDataName();
            int n = string.length() - FmtFileType.REPORT.extension().length();
            string = string.substring(0, n);
        }
        string = string + FmtFileType.HTML.extension();
        this.setFileType(FmtFileType.HTML);
        String string2 = this.m_report.getFileName();
        this.m_report.setFileName(string);
        FileSelectDlg fileSelectDlg = FmtEditorMain.instance().startSave(this);
        this.setFileType(FmtFileType.REPORT);
        this.m_report.setFileName(string2);
        if (fileSelectDlg == null) {
            return;
        }
        this.disableAll();
        HtmlSummaryReport htmlSummaryReport = new HtmlSummaryReport(this.getDataName(), fileSelectDlg.getFileName(), this.m_table);
        htmlSummaryReport.generateReport();
        this.enableWithCheck();
    }

    private void configureTable() {
        JFrame jFrame = (JFrame)this.getTopLevelAncestor();
        ConfigureDialog configureDialog = new ConfigureDialog(jFrame, this.m_table);
        configureDialog.setVisible(true);
        if (configureDialog.wasCanceled()) {
            return;
        }
        configureDialog.configureTable();
    }

    public RemoteInstrument getInstrument() {
        return this.m_connect.getInstrument();
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        this.m_connect.setInstrument(remoteInstrument);
    }

    public boolean isLocalFile() {
        return true;
    }

    public boolean supportsRemoteFiles() {
        return false;
    }

    private class FmtTableTransfer
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return false;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            int n = FmtReportFrame.this.m_table.getSelectedRow();
            FmtTableEntry fmtTableEntry = FmtReportFrame.this.m_table.getData().getEntry(n);
            String string = fmtTableEntry == null ? "" : fmtTableEntry.fullName();
            return new FmtTransferable(string);
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            return false;
        }
    }

    private class ProgSetter
    implements Runnable {
        private int m_value;
        private String m_msg;

        public ProgSetter(int n, String string) {
            this.m_value = n;
            this.m_msg = string;
        }

        public void run() {
            FmtReportFrame.this.m_progBar.setValue(this.m_value);
            FmtReportFrame.this.m_progBar.setString(String.format("%d of %d:  ", this.m_value, FmtReportFrame.this.m_progBar.getMaximum()) + this.m_msg);
        }
    }

    private class ProgStarter
    implements Runnable {
        private int m_min;
        private int m_max;
        private String m_msg;

        public ProgStarter(int n, int n2, String string) {
            this.m_min = n;
            this.m_max = n2;
            this.m_msg = string;
        }

        public void run() {
            FmtReportFrame.this.m_cancelBtn.setVisible(true);
            FmtReportFrame.this.m_progBar.setVisible(true);
            FmtReportFrame.this.m_progBar.setIndeterminate(false);
            FmtReportFrame.this.m_progBar.setMinimum(this.m_min);
            FmtReportFrame.this.m_progBar.setMaximum(this.m_max);
            FmtReportFrame.this.m_progBar.setStringPainted(true);
            FmtReportFrame.this.m_progBar.setString(this.m_msg);
            FmtReportFrame.this.m_progBar.setValue(this.m_min);
        }
    }

    private class Filler
    extends Thread {
        private Filler() {
        }

        public void run() {
            FmtReportFrame.this.loadTable();
        }
    }
}

